/*
 * instrument.c
 *
 * Basic code for GPIB over RS232C style control of instruments,
 * like the TAS 240, or the TAS1200D
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2007 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: instrument.h,v 1.1.1.1 2007/06/09 06:31:18 steveu Exp $
 */

#if !defined(_INSTRUMENT_H_)
#define _INSTRUMENT_H_

typedef struct
{
    int code;
    const char *explanation;
} tag_t;

typedef struct
{
    int fd;
    tag_t *error_codes;    
} instr_t;

#if defined(__cplusplus)
extern "C"
{
#endif

instr_t *instr_open(const char *dev, int speed, tag_t *error_codes);

int instr_close(instr_t *inst);

int instr_exchange(const instr_t *inst, const char *request, char *response, ...);

int instr_exchange_c(const instr_t *inst, const char *request, ...);

const char *scan_for_field(const char *field_id, const char *response, char *field);

const char *display_explanation(tag_t tags[], int code);

#if defined(__cplusplus)
}
#endif

#endif
/*- End of file ------------------------------------------------------------*/
