/*
 * protocol mfcr2 - a unicall protocol library for MFC/R2 signaling on E1 lines
 *
 * libmfcr2.h
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2002 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 2.1,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: libmfcr2.h,v 1.9 2008/07/06 11:15:55 steveu Exp $
 */

/*! \file */

#if !defined(_LIBMFCR2_H_)
#define _LIBMFCR2_H_

typedef struct mfcr2_signaling_state_s mfcr2_signaling_state_t;

enum
{
    MFCR2_PROTOCOL_FAIL_T1_TIMEOUT              = 0x8001,
    MFCR2_PROTOCOL_FAIL_T2_TIMEOUT              = 0x8002,
    MFCR2_PROTOCOL_FAIL_T3_TIMEOUT              = 0x8003,
    MFCR2_PROTOCOL_FAIL_UNEXPECTED_MF_SIGNAL    = 0x8004,
    MFCR2_PROTOCOL_FAIL_UNEXPECTED_CAS          = 0x8005,
    MFCR2_PROTOCOL_FAIL_INVALID_STATE           = 0x8006,
    MFCR2_PROTOCOL_FAIL_SET_CAS_FAILURE         = 0x8007,
    MFCR2_PROTOCOL_FAIL_SEIZE_ACK_TIMEOUT       = 0x8008,
    MFCR2_PROTOCOL_FAIL_T1B_TIMEOUT             = 0x8009
};

#endif
