/*
 * libsupertone - A library to handle all the world's telephony supervisory tones.
 *
 * supertone_tests.c
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2004 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 2.1,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: supertone_tests.c,v 1.9 2008/04/07 14:12:30 steveu Exp $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdarg.h>
#include <math.h>
#include <inttypes.h>
#include <unistd.h>
#include <string.h>
#include <strings.h>
#include <errno.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/ioctl.h>

#if defined(HAVE_AUDIOFILE_H)
#include <audiofile.h>
#endif
#include <spandsp.h>

#include "libsupertone.h"

#define OUT_FILE_NAME   "super_tone.wav"

#define BLOCK_LEN       160

static void super_tone_detected(void *user_data, int tone_id, int level, int delay)
{
    printf("Detected tone %d, level %d\n", tone_id, level);
}
/*- End of function --------------------------------------------------------*/

int main(int argc, char *argv[])
{
#if defined(HAVE_AUDIOFILE_H)
    AFfilehandle outhandle;
    AFfilesetup filesetup;
#endif
    super_tone_set_t *set;
    super_tone_tx_state_t tx_state;
    super_tone_rx_state_t *rx_state;
    const char *where;
    int16_t amp[BLOCK_LEN];
    int i;
    int len;
    int outframes;
    
    where = "hk";
    if (argc > 1)
        where = argv[1];
    /*endif*/
    set = get_supervisory_tone_set(where);
    if (set == NULL)
        exit(2);
    /*endif*/
    printf("Tone set loaded\n");
    printf("Tone %d '%s'\n", 0, set->tone_names[0]);
    printf("Tone %d '%s'\n", 1, set->tone_names[1]);
    printf("Tone %d '%s'\n", 2, set->tone_names[2]);

#if defined(HAVE_AUDIOFILE_H)
    filesetup = afNewFileSetup ();
    if (filesetup == AF_NULL_FILESETUP)
    {
    	fprintf(stderr, "    Failed to create file setup\n");
        exit(2);
    }
    /*endif*/
    afInitSampleFormat(filesetup, AF_DEFAULT_TRACK, AF_SAMPFMT_TWOSCOMP, 16);
    afInitRate(filesetup, AF_DEFAULT_TRACK, 8000.0);
    //afInitCompression(filesetup, AF_DEFAULT_TRACK, AF_COMPRESSION_G711_ALAW);
    afInitFileFormat(filesetup, AF_FILE_WAVE);
    afInitChannels(filesetup, AF_DEFAULT_TRACK, 1);

    outhandle = afOpenFile(OUT_FILE_NAME, "w", filesetup);
    if (outhandle == AF_NULL_FILEHANDLE)
    {
        fprintf(stderr, "    Cannot open audio file '%s'\n", OUT_FILE_NAME);
        exit(2);
    }
    /*endif*/
#else
    printf("Audiofile not present, so no wave file generated.\n");
#endif
    if ((rx_state = super_tone_rx_init(NULL, set->tone_detector, super_tone_detected, NULL)) == NULL)
        exit(2);
    /*endif*/

    //super_tone_tx_init(&tx_state, set->tone[ST_TYPE_DIALTONE]);
    super_tone_tx_init(&tx_state, set->tone[ST_TYPE_RINGBACK]);

    for (i = 0;  i < 250;  i++)
    {
        len = super_tone_tx(&tx_state, amp, BLOCK_LEN);
#if defined(HAVE_AUDIOFILE_H)
        outframes = afWriteFrames(outhandle,
                                  AF_DEFAULT_TRACK,
                                  amp,
                                  len);
        if (outframes != len)
        {
            fprintf(stderr, "    Error writing wave file\n");
            exit(2);
        }
#endif
        super_tone_rx(rx_state, amp, len);
    }
    /*endfor*/
    for (i = 0;  i < 250;  i++)
    {
        memset(amp, 0, sizeof(int16_t)*BLOCK_LEN);
        len = BLOCK_LEN;
#if defined(HAVE_AUDIOFILE_H)
        outframes = afWriteFrames(outhandle,
                                  AF_DEFAULT_TRACK,
                                  amp,
                                  len);
        if (outframes != len)
        {
            fprintf(stderr, "    Error writing wave file\n");
            exit(2);
        }
#endif
        super_tone_rx(rx_state, amp, len);
    }
    /*endfor*/
#if defined(HAVE_AUDIOFILE_H)
    if (afCloseFile (outhandle) != 0)
    {
        fprintf(stderr, "    Cannot close audio file '%s'\n", OUT_FILE_NAME);
        exit(2);
    }
    /*endif*/
#endif
    return 0;
}
/*- End of function --------------------------------------------------------*/
/*- End of file ------------------------------------------------------------*/
