/*
 * libt31 - A Unicall protocol module which emulates a T.31 compatible modem
 *
 * t31.h
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2004 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: t31.h,v 1.2 2004/10/30 14:01:04 steveu Exp $
 */

#if !defined(_T31x_H_)
#define _T31x_H_

/* This structure should contain everything to control a signaling channel. */
struct t31_signaling_state_s
{
    /*! \brief The front end (E1) device handle */
    int fe_handle;
    /*! \brief */
    int pts_handle;
    /*! \brief TRUE if we have cleared forward. */
    int cleared_fwd;
    /*! \brief The current compelled signalling state of the protocol. */
    int call_state;
    /*! \brief The call type - Free, charged, etc. */
    int call_type;
    /*! \brief TRUE if an incoming call is in progress. */
    int incoming_call;
    /*! \brief Timer used to ensure we do not seize to aggressively as the far end unblocks. */
    int far_unblocking_timer;
    /*! \brief Timer used to ensure we do not seize to aggressively after we unblock. */
    int local_unblocking_timer;
    /*! \brief The seize acknowledge timeout, used to detect failure at the remote end. */
    int seize_ack_timer;
    /*! \brief The release guard timeout. */
    int release_guard_timer;
    int wait_for_answer_timer;
    /*! \brief The MF tone on timer, at the outgoing side. */
    int t1_timer;
    /*! \brief The MF tone pulse timer, at the incoming side. This is only used
               for variants which use non-compelled MF6 tone pulses to restart
               activities after certain timeouts. */
    int t1a_timer;
    /*! \brief The MF tone off timer, at the outgoing side. */
    int t2_timer;
    /*! \brief The compelled cycle timer, at the incoming side. */
    int t3_timer;
    int far_blocked;
    int local_blocked;

    /* Configuration parameters, to adapt to different countries. */
    /*! \brief The number of DNIS digits we expect for incoming calls. Some national
               variants do not handle variable length dialed digit strings well. In
               those cases it is important to set this correctly. For other variants,
               a large number is OK. */
    int dnis_num_rx_digits;
    /*! \brief The number of ANI digits we expect for incoming calls. */
    int ani_max_rx_digits;

    /*! \brief */
    int blocking_release_time;
    /*! \brief */
    int answer_guard_time;
    /*! \brief Zero may be OK */
    int release_guard_time;
    /*! \brief 20ms should be OK */
    int inbound_cas_persistence_check;
    /*! \brief 20ms should be OK */
    int outbound_cas_persistence_check;
    /*! ITU spec says 200ms */
    int max_seize_ack_wait;
    /*! \brief The maximum time we will for the called party to answer, after the
               call setup is complete. 60s is common practice */
    int max_wait_for_answer;
    /*! \brief The maximum time we will wait for the group B signal. 15s is common
               practice */
    int max_wait_for_group_b_signal;
    /*! \brief Clear back persistence check, in milliseconds. This can be zero for
               most purposes */
    int clear_back_persistence_check;
    /*! \brief All trunks are able to accept incoming calls. This flag is TRUE if the
               trunk is permitted to also make outgoing calls. */
    int outgoing_calls_allowed;
    
    uc_call_t *call;
    
    /*! \brief Debug audio receive log file handle. */
    int audio_rx_log;
    /*! \brief Debug audio transmit log file handle. */
    int audio_tx_log;
    
    char *pts_name;
    char *tty_name;
    t31_state_t t31_state;
};

#endif
