/*
 * build-tone-set.h
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2004 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: libsupertone.h,v 1.4 2005/07/10 07:14:59 steveu Exp $
 */

#if !defined(_LIBSUPERTONE_H_)
#define _LIBSUPERTONE_H_

enum
{
    ST_TYPE_NONE = 0,
    ST_TYPE_DIALTONE,
    ST_TYPE_RINGBACK,
    ST_TYPE_BUSY,
    ST_TYPE_NU,
    ST_TYPE_CONGESTED,
    ST_TYPE_DISCONNECTED
};

/* This structure should contain a complete supervisory tone set. */
typedef struct
{
    const char *uncode;
    const char *country;
    super_tone_tx_step_t *tone[7];
    super_tone_rx_descriptor_t *tone_detector;
    const char *tone_names[20];
    const char *tone_domains[20];
    int tone_types[20];
    int ring_patterns[10][10];
} super_tone_set_t;

super_tone_set_t *get_supervisory_tone_set(char *set_id);

#endif
/*- End of file ------------------------------------------------------------*/
