/*
 * LibStream - a library for media streaming.
 *
 * tpkt_tests.c - An implementation of RFC1006, mostly for T.38
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2006 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: tpkt_tests.c,v 1.6 2007/02/12 14:01:50 steveu Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <inttypes.h>
#include <unistd.h>
#include <sys/uio.h>
#include <math.h>
#include <memory.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <sys/select.h>
#include <sys/time.h>

#include "libstream.h"

#define STREAM_LEN  10000000

uint8_t buffer[STREAM_LEN];
int total_len;
int step;
int bad_messages;
tpkt_state_t tpkt_state;

static int process_test_msg(void *user_data, const uint8_t buf[], int len)
{
    int msg_len;

    msg_len = ntohs(((int16_t *) (buffer + step))[1]);
    if (len != msg_len - 4)
    {
        printf("Bad length - %d %d\n", len, msg_len - 4);
        bad_messages++;
        return 0;
    }
    if (memcmp(buf, buffer + step + 4, len))
    {
        printf("Bad content\n");
        bad_messages++;
        return 0;
    }
#if 0
    printf("Packet is %d bytes\n", len);
    for (i = 0;  i < len;  i++)
        printf("%02x ", buf[i]);
    printf("\n");
#endif
    step += msg_len;
    return 0;
}
/*- End of function --------------------------------------------------------*/

static int back_to_back_tests(void)
{
    tpkt_state_t *tpkt;
    int len;
    int i;
    int runs;
    uint8_t msg[256];
    int msg_len;
    int total_msgs;
    int min_msg;
    int max_msg;


    if ((tpkt = tpkt_init(NULL, process_test_msg, NULL)) == NULL)
    {
        printf("Test failed\n");
        exit(2);
    }

    for (i = 0;  i < 256;  i++)
        msg[i] = i;
    total_msgs = 0;
    min_msg = 99999;
    max_msg = 0;
    for (runs = 0;  runs < 100;  runs++)
    {
        /* Create a substantial stream of messages, of varying length, using the
           TPKT encoder. */
        for (i = 0;  i < STREAM_LEN - 150;  i += len)
        {
            msg_len = rand() & 0x3FF;
            len = tpkt_build_packet(tpkt, buffer + i, msg, msg_len);
            total_msgs++;
            if (msg_len < min_msg)
                min_msg = msg_len;
            if (msg_len > max_msg)
                max_msg = msg_len;
            //printf("Msg len %d\n", msg_len);
        }
        /* Pump these through the TPKT decoder, and see if they come out right */
        total_len = i;
        step = 0;
        bad_messages = 0;
        for (i = 0;  i < total_len;  i += len)
        {
            len = rand() & 0xFF;
            if (len > total_len - i)
                len = total_len - i;
            if (tpkt_rx_chunk(tpkt, buffer + i, len))
            {
                printf("Bad return code!\n");
                exit(2);
            }
        }
        if (bad_messages)
        {
            printf("Test failed\n");
            exit(2);
        }
    }
    printf("Messages: %d\n", total_msgs);
    printf("Min len:  %d\n", min_msg);
    printf("Max len:  %d\n", max_msg);
    printf("Test passed\n");
    return 0;
}
/*- End of function --------------------------------------------------------*/

int main(int argc, char *argv[])
{
    /* Test out the packet creation and spliting in isolation from networking */
    back_to_back_tests();

    printf("Tests passed\n");
    return  0;
}
/*- End of function --------------------------------------------------------*/
/*- End of file ------------------------------------------------------------*/
