/*
 * LibStream - a library for media streaming.
 *
 * rfc3389.h - Real-time Transport Protocol (RTP) payload for comfort noise (CN)
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2006 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: rfc3389.h,v 1.4 2007/02/10 11:53:15 steveu Exp $
 */

/*! \file */

#if !defined(_RFC3389_H_)
#define _RFC3389_H_

typedef struct
{
    int payload_type;
    rfc3550_state_t *rfc3550_state;

    int resp;
} rfc3389_state_t;

#if defined(__cplusplus)
extern "C" {
#endif

int rfc3389_process_rx_packet(void *user_data,
                              uint16_t seq_no,
                              uint32_t timestamp,
                              uint32_t ssrc,
                              int payload_type,
                              int mark,
                              const uint8_t buf[],
                              int len);

int rfc3389_send(rfc3389_state_t *s, uint8_t buf[], int level, int coeffs, int rc[]);

rfc3389_state_t *rfc3389_init(rfc3389_state_t *s, rfc3550_state_t *t, int payload_type);

int rfc3389_release(rfc3389_state_t *s);

#if defined(__cplusplus)
}
#endif

#endif
/*- End of file ------------------------------------------------------------*/
