#!/bin/sh
#
# LibStream regression tests
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2, as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# $Id: regression_tests.sh,v 1.4 2007/02/13 13:38:52 steveu Exp $
#

ITUTESTS_TIF=../itutests/fax/itutests.tif
STDOUT_DEST=xyzzy
STDERR_DEST=xyzzy2

echo Performing basic regression tests for libstream
echo

./rfc2198_tests >$STDOUT_DEST 2>$STDERR_DEST
RETVAL=$?
if [ $RETVAL != 0 ]
then
    echo rfc2198_tests failed!
    exit $RETVAL
fi
echo rfc2198_tests completed OK

./rfc3550_tests >$STDOUT_DEST 2>$STDERR_DEST
RETVAL=$?
if [ $RETVAL != 0 ]
then
    echo rfc3550_tests failed!
    exit $RETVAL
fi
echo rfc3550_tests completed OK

./rfc4733_tests >$STDOUT_DEST 2>$STDERR_DEST
RETVAL=$?
if [ $RETVAL != 0 ]
then
    echo rfc4733_tests failed!
    exit $RETVAL
fi
echo rfc4733_tests completed OK

./tpkt_tests >$STDOUT_DEST 2>$STDERR_DEST
RETVAL=$?
if [ $RETVAL != 0 ]
then
    echo tpkt_tests failed!
    exit $RETVAL
fi
echo tpkt_tests completed OK

./udptl_tests >$STDOUT_DEST 2>$STDERR_DEST
RETVAL=$?
if [ $RETVAL != 0 ]
then
    echo udptl_tests failed!
    exit $RETVAL
fi
echo udptl_tests completed OK

echo
echo All regression tests successfully completed
