/*
 * LibStream - a library for media streaming.
 *
 * rfc4733_tests.c - RTP payload for DTMF digits, telephony tones and telephony signals tests
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2006 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: rfc4733_tests.c,v 1.1 2007/02/13 13:38:52 steveu Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <inttypes.h>
#include <math.h>
#include <memory.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <sys/select.h>
#include <sys/time.h>

#include "libstream.h"

#define FALSE 0
#define TRUE (!FALSE)

rfc3550_state_t rfc3550_state;
rfc2198_state_t rfc2198_state;
rfc4733_state_t rfc4733_state;
udp_state_t *s;

#define STREAM_LEN  10000000

uint8_t buffer[STREAM_LEN];
int total_len;
int rx_len;
int step;
int bad_messages;

int done[2] = {FALSE, FALSE};
int succeeded[2] = {FALSE, FALSE};

static int rfc4733_event_handler(void *user_data, int volume, int duration, int event_end, int freqs, int frequencies[])
{
    if (frequencies)
        printf("RFC4733 tone - %d, duration %d, volume %d\n", freqs, duration, volume);
    else
        printf("RFC4733 event - %s (%d), duration %d, volume %d\n", rfc4733_event_to_str(freqs), freqs, duration, volume);
    return 0;
}

static void back_to_back_tests(void)
{
    int i;
    uint8_t buf[4096];
    int len;
    int freq[16];

    if ((rfc3550_init(&rfc3550_state, 1)) == NULL)
    {
        printf("Test failed\n");
        exit(2);
    }
    if ((rfc2198_init(&rfc2198_state, &rfc3550_state, 3, 42)) == NULL)
    {
        printf("Test failed\n");
        exit(2);
    }
    if ((rfc4733_init(&rfc4733_state, &rfc3550_state, 43, 44, rfc4733_event_handler, NULL)) == NULL)
    {
        printf("Test failed\n");
        exit(2);
    }

    for (i = 0;  i < 17;  i++)
    {
        len = rfc4733_event_send(&rfc4733_state, buf, i, 6 + i, 7 + i, 0);
        rfc3550_rx_rtp_packet(&rfc3550_state, buf, len);
    }
    freq[0] = 400;
    freq[1] = 440;
    len = rfc4733_tone_send(&rfc4733_state, buf, 123, 6, 7, 2, freq);
    rfc3550_rx_rtp_packet(&rfc3550_state, buf, len);
    
    /* Add Cisco DTMF handling */
    rfc4733_set_cisco_dtmf_type(&rfc4733_state, 45);
    len = rfc4733_cisco_dtmf_send(&rfc4733_state, buf, RFC4733_EVENT_DTMF_5);
    rfc3550_rx_rtp_packet(&rfc3550_state, buf, len);
}
/*- End of function --------------------------------------------------------*/

int main(int argc, char *argv[])
{
    back_to_back_tests();

    printf("Tests passed\n");
    return  0;
}
/*- End of function --------------------------------------------------------*/
/*- End of file ------------------------------------------------------------*/
