/*
 * Vale - a library for media streaming.
 *
 * rfc2198.h - RTP redundancy
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2006 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: rfc2198.h,v 1.1.1.1 2007/04/03 13:13:37 steveu Exp $
 */

/*! \file */

#if !defined(_VALE_RFC2198_H_)
#define _VALE_RFC2198_H_

#define LOCAL_MAX_RFC2198_DATAGRAM      400

#define RFC2198_BUF_MASK                15

typedef struct
{
    int payload_type;
    uint32_t timestamp;
    int buf_len;
    uint8_t buf[LOCAL_MAX_RFC2198_DATAGRAM];
} rfc2198_red_tx_buffer_t;

typedef struct
{
    int payload_type;
    rfc3550_state_t *rfc3550_state;

    /*! This option indicates the number of redundancy entries transmitted in
        RFC2198 packets. */
    int redundant_entries;

    /*! This option indicates the maximum size of a datagram that can be accepted by
        the remote device. */
    int far_max_datagram_size;

    /*! This option indicates the maximum size of a datagram that we are prepared to
        accept. */
    int local_max_datagram_size;

    int verbose;

    int tx_seq_no;
    int rx_seq_no;
    int rx_expected_seq_no;

    rfc2198_red_tx_buffer_t tx[RFC2198_BUF_MASK + 1];
} rfc2198_state_t;

#if defined(__cplusplus)
extern "C"
{
#endif

int rfc2198_process_rx_packet(void *user_data,
                              const uint8_t buf[],
                              int len,
                              uint16_t seq_no,
                              uint32_t timestamp,
                              uint32_t ssrc,
                              int payload_type,
                              int mark);

int rfc2198_build_packet(rfc2198_state_t *s,
                         const uint8_t msg[],
                         int msg_len,
                         uint8_t buf[],
                         uint32_t timestamp,
                         int payload_type,
                         int mark);

rfc2198_state_t *rfc2198_init(rfc2198_state_t *s,
                              rfc3550_state_t *t,
                              int redundant_entries,
                              int payload_type);

int rfc2198_release(rfc2198_state_t *s);

#if defined(__cplusplus)
}
#endif

#endif
/*- End of file ------------------------------------------------------------*/
