/*
 * Vale - a library for media streaming.
 *
 * tcp.h - A simple abstraction of TCP connections.
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2007 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: tcp.h,v 1.1.1.1 2007/04/03 13:13:37 steveu Exp $
 */

/*
 * \file tcp.h
 *
 */

#if !defined(_VALE_TCP_H_)
#define _VALE_TCP_H_

#if !defined(FALSE)
#define FALSE 0
#endif
#if !defined(TRUE)
#define TRUE (!FALSE)
#endif

typedef struct tcp_state_s tcp_state_t;

#if defined(__cplusplus)
extern "C"
{
#endif

tcp_state_t *tcp_socket_create(void);

tcp_state_t *tcp_socket_create_and_bind(struct in_addr *addr, int startport, int endport);

int tcp_socket_destroy(tcp_state_t *s);

int tcp_socket_restart(tcp_state_t *s);

int tcp_socket_fd(tcp_state_t *s);

int tcp_socket_set_local(tcp_state_t *s, const struct sockaddr_in *us);

void tcp_socket_set_far(tcp_state_t *s, const struct sockaddr_in *far);

int tcp_socket_set_tos(tcp_state_t *s, int tos);

const struct sockaddr_in *tcp_socket_get_local(tcp_state_t *s);

const struct sockaddr_in *tcp_socket_get_far(tcp_state_t *s);

int tcp_socket_connect(tcp_state_t *s);

int tcp_socket_connection_result(tcp_state_t *s);

int tcp_socket_listen(tcp_state_t *s);

tcp_state_t *tcp_socket_accept(tcp_state_t *s);

int tcp_socket_recv(tcp_state_t *s, void *buf, size_t size, int flags);

int tcp_socket_send(tcp_state_t *s, const void *buf, size_t size, int flags);

int tcp_socket_send_with_header(tcp_state_t *s, const void *hdr_buf, size_t hdr_size, const void *buf, size_t size);

#if defined(__cplusplus)
}
#endif

#endif
/*- End of file ------------------------------------------------------------*/
