/*
 * Vale - a library for media streaming.
 *
 * tpkt.h - An implementation of RFC1006, mostly for T.38
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2005 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: tpkt.h,v 1.1.1.1 2007/04/03 13:13:37 steveu Exp $
 */

/*! \file */

#if !defined(_VALE_TPKT_H_)
#define _VALE_TPKT_H_

#define LOCAL_FAX_MAX_DATAGRAM      400
#define LOCAL_FAX_MAX_FEC_PACKETS   5

typedef int (tpkt_rx_packet_handler_t)(void *user_data, const uint8_t msg[], int len);

typedef struct
{
    tpkt_rx_packet_handler_t *rx_packet_handler;
    void *user_data;

    uint8_t msg[65535];
    int msg_len;

    int verbose;
} tpkt_state_t;

#if defined(__cplusplus)
extern "C"
{
#endif

int tpkt_rx_chunk(tpkt_state_t *s, const uint8_t buf[], int len);

int tpkt_build_packet(tpkt_state_t *s, uint8_t buf[], const uint8_t msg[], int msg_len);

int tpkt_build_header(tpkt_state_t *s, uint8_t buf[], const uint8_t msg[], int msg_len);

tpkt_state_t *tpkt_init(tpkt_state_t *s,
                        tpkt_rx_packet_handler_t rx_packet_handler,
                        void *user_data);

#if defined(__cplusplus)
}
#endif

#endif
/*- End of file ------------------------------------------------------------*/
